﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class LegendAnimations : MonoBehaviour
{
    public enum LegendButtonState
    {
        Hidden,
        Start,
        Showing,
        Idle,
        Hiding,
        Pressing
    }

    public Animator Animator;

    public LegendButtonState ButtonState { get; private set; }  //The current state of the legend button

    /// <summary>
    /// Sets the state of the legend button to the new desired state
    /// </summary>
    /// <param name="state">The new state of the legend button</param>
    public void SetButtonState(LegendButtonState state)
    {
        if (ButtonState != state && Animator != null)
        {
            //We've got a new state and an animation, update the variable and set the ButtonState parameter
            ButtonState = state;
            Animator.SetInteger("ButtonState", (int)ButtonState);
        }
    }
}
